const { BasicComponent, Anime } = require('@kenlo/guidelines');
const { cloneDeep } = require('lodash');

class Component {
  onCreate() {
    this.state = {
      nameList: [],
    };
  }

  addNameToList(name) {
    const nameList = cloneDeep(this.state.nameList);
    nameList.push(name);
    this.setState({ nameList });
    this.setStateDirty('nameList');
  }

  removeNameFromList(index) {
    const nameList = cloneDeep(this.state.nameList);
    nameList.splice(index, 1);
    this.setState({ nameList: [] });
    setTimeout(() => {
      this.setState({ nameList });
    }, 100);
    this.setStateDirty('nameList');
  }

  removeName(index) {
    Anime({
      targets: this.getEl(`item-${index}`),
      translateX: 100,
      opacity: 0,
      complete: () => {
        this.removeNameFromList(index);
      },
    });
  }
}

module.exports = BasicComponent(Component);
